@extends('dashboards.blank')

@section('content')
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>All Colourants</h1>
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only"> Toogle Navigation </span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
        </div>
        <style>
            .link {
                position: absolute;
                bottom: 20px;
                right: 44px;
            }
        </style>
        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (count($errors) > 0)
                        @foreach ($errors->all() as $error)
                            <p class="alert alert-danger">{{ $error }}</p>
                        @endforeach
                    @endif


                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <span class="caption-subject font-red bold uppercase">Base in Liter</span>
                                    </div>
                                    <div class="protlet-body">
                                        <table class="table table-striped table-bordered    " id="sample_3">
                                            <thead>
                                                <tr>
                                                    <th> S/N</th>
                                                    <th>Colourant Name</th>
                                                    <th>Colourant Code</th>
                                                    <th>price(/ml)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <form method="post" class="delete" action="/dashboard/colourant">
                                                    @method('PATCH')
                                                    @csrf
                                                    @foreach ($colorants as $colorant)
                                                        <?php
                                                        $r = $colorant->rvalue;
                                                        $g = $colorant->gvalue;
                                                        $b = $colorant->bvalue;
                                                        $luminance = (0.299 * $r + 0.587 * $g + 0.114 * $b) / 255;
                                                        $textColor = $luminance > 0.6 ? 'black' : 'white';
                                                        ?>
                                                        <tr class="colorcode"
                                                            style="background:rgb({{ $r }}, {{ $g }}, {{ $b }});color:{{ $textColor }};">
                                                            <td style="font-weight: bold; color:{{ $textColor }};">
                                                                {{ $loop->iteration }}
                                                            </td>
                                                            <td style="font-weight: bold; color:{{ $textColor }};">
                                                                {{ $colorant->colorantName }}</td>
                                                            <td style="font-weight: bold; color:{{ $textColor }};">
                                                                {{ $colorant->colorantCode }}</td>
                                                            <td><input type="number" min="0" step="0.01"
                                                                    class="form-control" name="price[]"
                                                                    value="{{ $colorant->unitPrice }}"></td>
                                                        </tr>
                                                    @endforeach

                                            </tbody>

                                            <span class="link">{{ $colorants->links() }}</span>
                                        </table>
                                        <button class="btn btn-primary btn-md">Update</button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <script>
                $(".delete").on("submit", function() {
                    return confirm("Are you sure, you want to update?");
                });
            </script>
        </div>
    </div>
@endsection
