@extends('dashboards.sessions.layout')

@section('content')
<style>
/* #ndp-nepali-box{
    top:200px !important;
} */
.text {
    color: black;
}

.dt-buttons {
    display: none;
}
.custom-margin{
    margin-left:5px;
}
.custom-margin-btn{
    margin-left:20px;
}
</style>
<div class="page-content">
    <div class="breadcrumbs">
        <h1>Schemes/Price List</h1>
        <!-- Sidebar Toggle Button -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
        <!-- Sidebar Toggle Button -->
    </div>

    <div class="page-content-container">
        <div class="page-content-row" id="replecable">
            <div class="page-sidebar">
                <div class="portlet light portlet-fit">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-bar font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                        </div>

                    </div>
                    <nav class="navbar" role="navigation">
                        <ul class="nav navbar-nav margin-bottom-35 bank-class">
                            <li class="active"><a href="/dashboard/consumerscheme/create">Add New</a></li>
                            <li><a href="/dashboard/consumerscheme">View All</a></li>
                        </ul>

                    </nav>
                </div>

            </div>
            <div class="page-content-col">

                @if(session('Status'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <b>{{ session('Status') }}</b>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light portlet-fit bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-upload font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Add Consumer Scheme</span>
                        </div>

                    </div>
                    <div class="protlet-body">
                        @if(count($errors) > 0)
                        @foreach($errors->all() as $error)
                        <p class="alert alert-danger">{{ $error }}</p>
                        @endforeach
                        @endif

                        <form action="/dashboard/consumerscheme" method="post">
                            @csrf
                            <div class="form-group row custom-margin">
                                <div class="col-md-3">
                                    <label>Batch No * </label>
                                </div>
                                <div class="col-md-8">
                                    <input type="string" class="form-control @error('batch') is-invalid @enderror"
                                        placeholder="Batch no." value="{{old('batch')}}" name="batch" required
                                        autofocus>
                                    @error('batch')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row custom-margin">
                                <label class="col-md-3">Date * </label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control @error('datetime') is-invalid @enderror"
                                        value="{{old('datetime')}}" name="datetime" required autofocus>
                                    @error('datetime')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group row custom-margin">
                                <label class="col-md-3">No of key * </label>
                                <div class="col-md-8">
                                    <input type="number" class="form-control @error('no_of_key') is-invalid @enderror"
                                        min="1" placeholder="no of product in this batch" value="{{old('no_of_key')}}"
                                        name="no_of_key" required autofocus>
                                    @error('no_of_key')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror

                                </div>
                            </div>
                            <div class="form-actions form-group custom-margin-btn">
                                <div class="text-left">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection