@extends('dashboards.sessions.layout')
@section('content')

<style>
    .dt-buttons {
        display: none;
    }
</style>
<div class="page-content">
    <div class="breadcrumbs">
        <h1>All Scheme List</h1>
        <!-- Sidebar Toggle Button -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
        <!-- Sidebar Toggle Button -->
    </div>

    <div class="page-content-container">
        <div class="page-content-row" id="replecable">
            <div class="page-sidebar">
                <div class="portlet light portlet-fit">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-bar font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                        </div>

                    </div>
                    <nav class="navbar" role="navigation">
                        <!-- Brand and toggle get grouped for better mobile display -->
                        <!-- Collect the nav links, forms, and other content for toggling -->
                        <ul class="nav navbar-nav margin-bottom-35">

                            <li><a href="/dashboard/consumerscheme/create">Add New </a></li>
                            <li class="active"><a href="/dashboard/consumerscheme">View All </a></li>

                        </ul>

                    </nav>
                </div>

            </div>
            <div class="page-content-col">
                @if(session('Status'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    <b>{{ session('Status') }}</b>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="row">
                    <div class="col-md-12 notice-content">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->

                        <div class="portlet light portlet-fit">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class="fa fa-envelope font-red"></i>
                                    <span class="caption-subject font-red bold uppercase">Scheme List</span>
                                </div>
                                <div>
                                <div class="tools"></div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" style="overflow-x:hidden;">
                                    <thead>
                                        <tr>

                                            <th> S/N</th>
                                            <th> Batch </th>
                                            <th> Actions </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (!empty($consumerschemes))

                                        @foreach($consumerschemes as $consumerscheme )
                                        <tr>
                                            <td>{{$consumerscheme ->id}}</td>
                                            <td>
                                                {{$consumerscheme ->batch}}
                                            </td>
                                            <td>
                                                <a href="/dashboard/consumerscheme/{{$consumerscheme->id}}" class="btn btn-primary">View </a>
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endif

                                    </tbody>
                                    {{$consumerschemes->links()}}
                                </table>
                            </div>

                        </div>
                    </div>

                    <!-- END SIDEBAR CONTENT LAYOUT -->
                </div>
            </div>
        </div>
    </div>
</div>

@endsection