@extends('dashboards.sessions.layout')
@section('content')
    <style>
        @media print {
            @page {
                /* size: 297mm 210mm; */
                size: A4 landscape !important;
                margin: 0mm !important;
                /* size: 287mm 210mm; */
            }
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>Print View</h1>
        </div>
        <div class="row">
            <div class="col-md-12 notice-content">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->

                <div class="portlet light portlet-fit">
                    <div class="portlet-title">
                        {{ $keys->links() }}
                        <div class="caption">
                            <i class="fa fa-envelope font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Scheme List</span>
                        </div>
                        <div>
                            <a href="" class="btn btn-outline btn-xs btn-primary" style="float:right"
                                onclick="printDiv('printMe')">Print</a>
                        </div>
                        <div class="tools"></div>
                    </div>
                    <div id="printMe">
                        <div class=""
                            style="display: grid;grid-template-columns: auto auto auto;grid-column-gap: 5px;">
                            @foreach ($keys as $key)
                                <div class="">
                                    <div style="position:relative;">
                                        <div style="height:8.27in;margin:0mm;padding:0mm;">
                                        </div>
                                        <div style="font-weight:bold;position:absolute;top: 6%;left: 22%;">
                                            {{ $key->key }}
                                        </div>
                                        <div style="font-weight:bold;position:absolute;top: 61%;left: 27%;">
                                            {{ $key->key }}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
            {{-- pop up after clicking view  --}}
            <div id="order-popup">


            </div>
        </div>

        <!-- END SIDEBAR CONTENT LAYOUT -->
    </div>
    </div>
    <script>
        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();
            document.margin = 'none';
            document.body.innerHTML = originalContents;

        }
    </script>
@endsection
