<style>
    input[type=text] {
        width: 100%;
    }

    .discount-header {
        height: 50px;
        background-color: #d7d7d7;
        border-radius: 3px;
        display: flex;
        align-items: center;
        padding-left: 16px;
        margin-bottom: 16px;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .product-category {
        border: 1px solid #d1d1d1;
        max-height: 350px;
        overflow-y: auto;
        overflow-x: hidden;
        border-radius: 5px;
    }

    .product-label {
        padding-left: 16px;
        border: 0px;
    }

    .product-label:focus {
        outline: none;
    }
</style>
<div class="page-content2">
    <img style="float:right;width:25px; height:25px;" onclick="document.getElementById('order-popup').style.display='none'" src={{ asset('assets/pages/img/quit.svg') }}>
    <div class="breadcrumbs">
        <h1>Edit Firm/Organization</h1>
        <!-- Sidebar Toggle Button -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
        <!-- Sidebar Toggle Button -->
    </div>

    <div class="page-content-container">
        <div class="page-content-row" id="replecable">
            <div class="page-content-col">
                @if(session('Status'))

                <div class="alert alert-success alert-dismissible" role="alert">
                    <b>{{ session('Status') }}</b>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                @endif
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light portlet-fit bordered">
                            <div class="portlet-title">
                                <div class="caption">
                                    <i class=" icon-map font-red"></i>
                                    <span class="caption-subject font-red bold uppercase">Edit Firm/Organization</span>
                                </div>

                            </div>

                            @if(count($errors) > 0)
                            @foreach($errors->all() as $error)
                            <p class="alert alert-danger">{{ $error }}</p>
                            @endforeach
                            @endif

                            <form method="POST" action="/dashboard/firm/{{ $firm->id }}">
                                {{ method_field('PATCH') }}
                                @csrf
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label for="name" class="col-md-3 col-form-label text-right">{{ __('Company/Firm Name') }}</label>

                                            <div class="col-md-6">
                                                <input type="text" class="form-control" value="{{ $firm->firm_name }}" name="firm_name" required autofocus>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="next_phone" class="col-md-3 col-form-label text-right">{{ __('Address') }}</label>

                                            <div class="col-md-6">
                                                <input type="text" class="form-control" value="{{ $firm->address }}" name="address" required autofocus>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="phone" class="col-md-3 col-form-label text-right">{{ __('Phone Number') }}</label>

                                            <div class="col-md-6">
                                                <input type="text" class="form-control" value="{{ $firm->phone_number }}" name="phone" required autofocus>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone" class="col-md-3 col-form-label text-right">{{ __('Order Limit') }}</label>

                                            <div class="col-md-6">
                                                <input type="text" class="form-control" value="{{ $firm->order_limit }}" name="limit" min="0" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                    <div class="product-category">
                                            <div class="discount-header">Discount on Product</div>
                                            <div class="form-group row">
                                                <label for="phone" class="col-md-4 col-form-label " style="margin-left:16px;">{{ __('Discount for all product') }}</label>
                                                <div class="col-md-5">
                                                    <input type="number" class="form-control" step="0.01" id="discount_apply" style="margin-right:16px;" placeholder="discount percentage" autofocus>
                                                </div>
                                                <div class="col-md-2">
                                                    <a class="btn btn-primary btn-sm" onclick="applyDiscount()" style="width: 123%;">Apply</a>
                                                </div>
                                            </div>
                                            @foreach($categories as $category)
                                                <div class="form-group">
                                                <label for="phone" class="col-md-12 product-label">{{ $category->name}}</label>
                                                <input for="category" name="product_name[]" class="col-md-12 product-label" value="{{$category->id}}" readonly type="hidden"/>
                                                    <div class="col-md-12">
                                                        <input type="number" min="0" max="100" step="0.01" class="form-control discount-product" name="discount[]"@foreach($firm->discount as $dis) @if($dis->category_id==$category->id) value="{{$dis->discount}}" @endif @endforeach placeholder="discount (percentage)" autofocus>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="form-group row mb-0">
                                            <div class="col-md-6">
                                                <button type="submit" class="btn btn-primary" style="width: 200px;margin-top:20px;">
                                                    {{ __('Update') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('#area').change(function(e) {
            $('.subarea-option').remove();

            var value = $(this).val();
            $.ajax({
                url: "/dashboard/subarea",
                type: "get",
                data: {
                    data: value,
                },
                success: function(response) {
                    $('#sub_area').append('<option value="" class="subarea-option">Select Sub Area</option>');
                    response.map(function(data) {
                        $('#sub_area').append('<option class="subarea-option" value="' + data.subarea + '">' + data.subarea + '</option>');
                    });
                }
            });
        });
    });
    function applyDiscount(){
        let discount = document.getElementById('discount_apply').value;
        let discountField = document.querySelectorAll('.discount-product');
        // if(discount){
        discountField.forEach(function(item){
            item.value=discount;
        });
    // }
    }

</script>