@extends('dashboards.sessions.layout')

@section('content')
    <style>
        .dt-buttons {
            display: none;
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>All Organization/Firms</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            <!-- Brand and toggle get grouped for better mobile display -->
                            <!-- Collect the nav links, forms, and other content for toggling -->
                            @include('dashboards.sidebarLayouts.user')

                        </nav>
                    </div>

                </div>
                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class=" icon-map font-red"></i>
                                        <span class="caption-subject font-red bold uppercase">Users(Dealer Owner)</span>
                                    </div>

                                </div>
                                <style>

                                </style>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="sample_2">
                                        <thead>
                                            <tr>
                                                <th style = "position:sticky;left:0; background:white;z-index:1">S/N</th>
                                                <th>Details</th>
                                                <th>Cheque in Hand</th>
                                                <th> Due Balance</th>
                                                <th>No. of Cheque in Hand</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (!empty($firms))
                                                @foreach ($firms as $firm)
                                                    <tr>
                                                        <td style ="position:sticky;left:0;">{{ $loop->iteration }}</td>
                                                        <td>
                                                            <span style=" font-weight:bold; "> Dealer code:
                                                                {{ $firm->dealer_code }}</span> <br>
                                                            <span style=" font-weight:bold; ">Firm
                                                                Name:</span>{{ $firm->firm_name }} <br>
                                                            <span
                                                                style=" font-weight:bold; ">Address:</span>{{ $firm->address }}
                                                            <br>
                                                            <span
                                                                style=" font-weight:bold; ">Contact:</span>{{ $firm->phone_number }}
                                                            <br>
                                                            <span style=" font-weight:bold; ">Order
                                                                Limit:</span>{{ $firm->order_limit ?? 0 }}
                                                        </td>
                                                        <td>
                                                            <form action="/dashboard/statement/{{ $firm->id }}"
                                                                method="post">
                                                                @csrf
                                                                @method('PATCH')
                                                                <input type="number" class="form-control col-md-2"
                                                                    name="cheque_in_hand"
                                                                    value="{{ $firm->cheque_in_hand ?? 0 }}" required>
                                                        </td>
                                                        <td>

                                                            <input type="number" name="due_amount"
                                                                class="form-control col-md-2"
                                                                value="{{ $firm->due_amount ?? 0 }}" required>

                                                        </td>
                                                        <td>

                                                            <div class="row">
                                                                <div class="col-md-8">
                                                                    <input type="number" name="number_of_cheque_in_hand"
                                                                        value="{{ $firm->cheque_nos ?? 0 }}"
                                                                        class="form-control col-md-8" required>
                                                                </div>
                                                                <div class="col-md-4"
                                                                    style="padding-left: 0px;margin-top:1px;">
                                                                    <button type="submit"
                                                                        class="btn btn-primary btn-sm ">Update</button>
                                                                </div>
                                                            </div>
                                                            </form>
                                                        </td>
                                                        <td>

                                                            <a href="/dashboard/firm/{{ $firm->id }}"
                                                                class='btn btn-primary btn-xs' style="margin-right:5px;">
                                                                View
                                                            </a>
                                                            <a id = "{{ $firm->id }}"
                                                                onclick = "document.getElementById('order-popup').style.display='block'"
                                                                class='btn green btn-outline btn-xs order-view-popup'
                                                                style="margin-right:5px;">Edit</a>
                                                            <a id = "{{ $firm->id }}"
                                                                onclick = "document.getElementById('order-popup').style.display='block'"
                                                                class='btn green btn-outline btn-xs discount-view-popup'
                                                                style="margin-right:5px;">Discount List</a>
                                                        </td>

                                                    </tr>
                                                @endforeach
                                            @endif

                                        </tbody>
                                    </table>

                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                            {{-- pop up after clicking view  --}}
                            <div id = "order-popup">


                            </div>
                            <script>
                                $(document).ready(function() {
                                    $(".order-view-popup").click(function() {
                                        var id = $(this).attr('id');
                                        $("#order-popup").load("/dashboard/firm/" + id + "/edit");
                                        $("#order-pop").css("display", "block");
                                        var modal = document.getElementById('order-popup');
                                        window.onclick = function(event) {
                                            if (event.target == modal) {
                                                modal.style.display = "none";
                                            }
                                        }
                                    });
                                    $(".password-view-popup").click(function() {
                                        var id = $(this).attr('id');
                                        $("#order-popup").load("/dashboard/userPassword/" + id + "/edit");
                                        $("#order-pop").css("display", "block");
                                        var modal = document.getElementById('order-popup');
                                        window.onclick = function(event) {
                                            if (event.target == modal) {
                                                modal.style.display = "none";
                                            }
                                        }
                                    });
                                    $(".discount-view-popup").click(function() {
                                        var id = $(this).attr('id');
                                        $("#order-popup").load("/dashboard/firm/discount/" + id);
                                        $("#order-pop").css("display", "block");
                                        var modal = document.getElementById('order-popup');
                                        window.onclick = function(event) {
                                            if (event.target == modal) {
                                                modal.style.display = "none";
                                            }
                                        }
                                    });

                                });
                            </script>
                        </div>

                        <!-- END SIDEBAR CONTENT LAYOUT -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
