@extends('dashboards.sessions.layout')

@section('content')
    <style>
        .dt-buttons {
            display: none;
        }
    </style>
    <!-- Ensure jQuery and Select2 are loaded BEFORE form -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>Colourant Meta Info </h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            @include('dashboards.sidebarLayouts.Miscellaneous')
                        </nav>
                    </div>

                </div>
                <div class="page-content-col">

                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class="fa fa-upload font-red"></i>
                                        <span class="caption-subject font-red bold uppercase">Colourant Info</span>
                                    </div>

                                </div>

                                @if (count($errors) > 0)
                                    @foreach ($errors->all() as $error)
                                        <p class="alert alert-danger">{{ $error }}</p>
                                    @endforeach
                                @endif

                                <form action="{{ route('house-previews.store') }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf

                                    <div class="form-group row">
                                        <label for="dealer_id" class="col-md-3 col-form-label text-right">Dealer</label>
                                        <div class="col-md-4">
                                            <select name="dealer_id" id="dealer_id" class="form-control select2" required>
                                                <option value="">Select Dealer</option>
                                                @foreach ($dealers as $dealer)
                                                    <option value="{{ $dealer->id }}"
                                                        {{ old('dealer_id') == $dealer->id ? 'selected' : '' }}>
                                                        {{ $dealer->firm_name }}</option>
                                                @endforeach
                                            </select>
                                            @error('dealer_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="client_id" class="col-md-3 col-form-label text-right">Client</label>
                                        <div class="col-md-4">
                                            <select name="client_id" id="client_id" class="form-control select2">
                                                <option value="">Select Client</option>
                                                @foreach ($clients as $client)
                                                    <option value="{{ $client->id }}"
                                                        {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                                        {{ $client->name }} ({{ $client->contact }}) </option>
                                                @endforeach
                                            </select>
                                            @error('client_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="type" class="col-md-3 col-form-label text-right">Type</label>
                                        <div class="col-md-4">
                                            <select name="type" id="type" class="form-control select2">
                                                <option value="">Select Type</option>
                                                <option value="Interior" {{ old('type') == 'Interior' ? 'selected' : '' }}>
                                                    Interior </option>
                                                <option value="Exterior" {{ old('type') == 'Exterior' ? 'selected' : '' }}>
                                                    Exterior </option>
                                            </select>
                                            @error('type')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div id="client-fields" style="display: {{ old('client_id') ? 'none' : 'block' }};">
                                        <div class="form-group row">
                                            <label for="client_name" class="col-md-3 col-form-label text-right">Client
                                                Name</label>
                                            <div class="col-md-4">
                                                <input type="text" name="client_name" id="client_name"
                                                    class="form-control" value="{{ old('client_name') }}"
                                                    {{ old('client_id') ? 'disabled' : '' }}>
                                                @error('client_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="client_address" class="col-md-3 col-form-label text-right">Client
                                                Address</label>
                                            <div class="col-md-4">
                                                <input type="text" name="client_address" id="client_address"
                                                    class="form-control" value="{{ old('client_address') }}"
                                                    {{ old('client_id') ? 'disabled' : '' }}>
                                                @error('client_address')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="client_contact" class="col-md-3 col-form-label text-right">Client
                                                Contact</label>
                                            <div class="col-md-4">
                                                <input type="text" name="client_contact" id="client_contact"
                                                    class="form-control" value="{{ old('client_contact') }}"
                                                    {{ old('client_id') ? 'disabled' : '' }}>
                                                @error('client_contact')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="original_file" class="col-md-3 col-form-label text-right">Original
                                            File</label>
                                        <div class="col-md-4">
                                            <input type="file" name="original_file" class="form-control"
                                                accept=".jpg,.jpeg,.png" required>
                                            @error('original_file')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="svg_file" class="col-md-3 col-form-label text-right">SVG File</label>
                                        <div class="col-md-4">
                                            <input type="file" name="svg_file" class="form-control" accept=".svg"
                                                required>
                                            @error('svg_file')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-md-8 col-md-offset-3">
                                            <button type="submit" class="btn btn-primary" style="width: 200px;">
                                                Upload
                                            </button>
                                        </div>
                                    </div>
                                    <script>
                                        $(document).ready(function() {
                                            if ($.fn.select2) {
                                                $('#dealer_id').select2({
                                                    theme: 'classic',
                                                    width: '100%',
                                                    placeholder: 'Select Dealer',
                                                    allowClear: true
                                                });
                                                $('#client_id').select2({
                                                    theme: 'classic',
                                                    width: '100%',
                                                    placeholder: 'Select Client',
                                                    allowClear: true
                                                });
                                            }

                                            function toggleClientFields() {
                                                if ($('#client_id').val()) {
                                                    $('#client-fields').hide();
                                                    $('#client_name').prop('disabled', true);
                                                    $('#client_address').prop('disabled', true);
                                                    $('#client_contact').prop('disabled', true);
                                                } else {
                                                    $('#client-fields').show();
                                                    $('#client_name').prop('disabled', false);
                                                    $('#client_address').prop('disabled', false);
                                                    $('#client_contact').prop('disabled', false);
                                                }
                                            }
                                            // Initial state on page load
                                            toggleClientFields();
                                            // On change
                                            $('#client_id').on('change', toggleClientFields);
                                        });
                                    </script>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
