@extends('dashboards.sessions.layout')

@section('content')
    <style>
        .dt-buttons {
            display: none;
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>House Preview</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick
                                    Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            @include('dashboards.sidebarLayouts.Miscellaneous')
                        </nav>
                    </div>

                </div>
                <div class="page-content-col">

                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('success') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            <b>{{ session('error') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class="fa fa-upload font-red"></i>
                                        <span class="caption-subject font-red bold uppercase">House
                                            Preview</span>
                                    </div>

                                </div>

                                <table id="imageAssetTable" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Dealer</th>
                                            <th>Client</th>
                                            <th>Image</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($imageAssets as $asset)
                                            <tr>
                                                <td>{{ $asset->id }}</td>
                                                <td>{{ $asset->dealer->firm_name ?? '-' }}</td>
                                                <td>{{ $asset->client->name ?? '-' }}</td>
                                                <td>
                                                    @if (!empty($asset->original_filename))
                                                        <a href="{{ asset('storage/' . $asset->original_filename) }}"
                                                            target="_blank">
                                                            <img src="{{ asset('storage/' . $asset->original_filename) }}"
                                                                alt="Image" style="max-width:80px;max-height:80px;">
                                                        </a>
                                                    @else
                                                        <img src="{{ asset('assets/pages/img/logos/logo.png') }}"
                                                            alt="Image" style="max-width:80px;max-height:80px;">
                                                    @endif
                                                </td>
                                                <td>{{ $asset->created_at }}</td>
                                                <td>
                                                    <a href="{{ route('house-previews.edit', $asset->id) }}"
                                                        class="btn btn-sm btn-primary">Edit</a>
                                                    <form action="{{ route('house-previews.destroy', $asset->id) }}"
                                                        method="POST" style="display:inline-block;"
                                                        onsubmit="return confirm('Are you sure you want to delete this item?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
