@extends('dashboards.blank')

@section('content')
    <div class="page-content">
        <!-- BEGIN BREADCRUMBS -->
        <div class="breadcrumbs">
            <h1>Items Details</h1>
            <ol class="breadcrumb">
                <li>
                    <button class="btn btn-success print" onclick="printDiv('printMe')"
                        style="margin-right: 30px;">Print</button>
                </li>
                <li>
                    <button class="btn btn-success print" onclick="printDiv('printMe',false)" style="margin-right: 30px;">Print
                        With
                        Amount</button>
                </li>
            </ol>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>
        <!-- END BREADCRUMBS -->
        <!-- BEGIN SIDEBAR CONTENT LAYOUT -->
        <style>
            .printOnly {
                /* text-align: center; */
                margin-left: 3%;

            }

            .amount {
                font-size: 16px !important;
                margin-left: 71%;
                font-weight: 600;
            }

            .total {
                font-size: 20px !important;
                font-weight: bold;
                text-align: center;
                vertical-align: middle !important;

                <style>@media print {
                    body * {
                        visibility: hidden !important;
                    }

                    #printMe,
                    #printMe * {
                        visibility: visible !important;
                    }

                    #printMe {
                        position: absolute;
                        left: 0;
                        top: 0;
                        width: 100vw;
                    }

                    .breadcrumbs,
                    .navbar-toggle,
                    .page-sidebar,
                    .navbar,
                    .sidebar,
                    .header,
                    .footer {
                        display: none !important;
                    }

                    @page {
                        margin: 0;
                    }
                }
        </style>
        <div class="row">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light portlet-fit bordered" id="printMe">
                    @php
                        $companyName = config('app.company_name');
                        $companyAddress = config('app.company_address');
                        $companyVat = config('app.company_vat');
                        $companyPhone = config('app.company_phone');
                        $today = date('Y-m-d');
                    @endphp
                    <div style="font-size: 24px;text-align: center;"> {{ $companyName }} </div>
                    <div style="font-size: 18px;text-align: center;">{{ $companyAddress }}</div>
                    <div style="width: 300px; float: right; margin-top: 20px; margin-right: 20px;">
                        <p style="line-height: 1.5;">
                            Vat No.: {{ $companyVat }} <br>
                            Date: {{ $today }} <br>
                            Phone No.: {{ $companyPhone }} <br>
                        </p>
                    </div>


                    @if (!empty($orders))
                        @if (!empty($mo))
                            <p class="printOnly" style="margin-top: 5%;"> M/S:{{ $mo }}</p>
                        @endif
                        @php
                            $firmName = $dealer->firm_name ?? 'N/A';
                            $address = $dealer->address ?? 'N/A';
                            $phone = $dealer->phone_number ?? 'N/A';
                            $panVat = $dealer->pan_vat_no ?? 'N/A';
                        @endphp
                        <p class="printOnly">
                            Dealer : {{ $firmName }}<br>
                            Address : {{ $address }}<br>
                            Contact : {{ $phone }}<br>
                            PAN / VAT : {{ $panVat }}<br>
                        </p>
                    @endif

                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-red bold uppercase">Challan</span>
                        </div>

                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_2">
                            <thead>
                                <tr>
                                    <th rowspan="2">S/N</th>
                                    <th rowspan="2">Particulars</th>
                                    @foreach ($sizes as $size)
                                        <th>{{ $size }}</th>
                                    @endforeach
                                    <th class="total-row" rowspan="2">Amount</th>
                                </tr>
                                <tr>
                                    @foreach ($sizes as $size)
                                        <th>Qty</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $grandTotal = 0;
                                @endphp
                                @foreach ($orders as $index => $order)
                                    @php
                                        $rowTotal = 0;
                                        $product = $order['product'] ?? '';
                                    @endphp
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $product }}</td>
                                        @foreach ($sizes as $size)
                                            @php
                                                $sizeData = $order['sizes'][$size] ?? [];
                                                $qty = $sizeData['qty'] ?? 0;
                                                $amt = $sizeData['amt'] ?? 0;
                                                $rowTotal += $amt;
                                            @endphp
                                            <td>{{ $qty > 0 ? $qty : '' }}</td>
                                        @endforeach
                                        <td class="total-row">Rs. {{ $rowTotal }}</td>
                                    </tr>
                                    @php $grandTotal += $rowTotal; @endphp
                                @endforeach
                                <tr class="total-row">
                                    <td colspan="{{ 2 + count($sizes) }}" style="font-weight: bold;">Total</td>
                                    <td> Rs. {{ $grandTotal }}</td>
                                </tr>
                            </tbody>

                            <!-- <a href="" class="btn btn-success btn-sm ab" style="margin-bottom:5px;"> Create Challan</a> -->
                        </table>

                        <style>
                            @media print {
                                #sample_2 {
                                    border-collapse: collapse;
                                    /* Merge borders */
                                    width: 100%;
                                }

                                #sample_2 th,
                                #sample_2 td {
                                    border: 2px solid black !important;
                                    /* Bold borders */
                                }

                                /* .total-row {
                                                                                                                                                                                                                                        display: none;
                                                                                                                                                                                                                                    } */
                            }
                        </style>

                        <div style="display:flex; justify-content: space-around;">
                            <span style="text-align: center;">
                                ......................................... <br>
                                Signature Of Customer
                            </span>
                            <span style="text-align: center;">
                                ................................ <br>
                                Order Booked By
                            </span>
                        </div>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>

            <!-- END SIDEBAR CONTENT LAYOUT -->
        </div>

    </div>

    <script>
        function printDiv(divName, hideTotal = true) {
            const printContents = document.getElementById(divName).innerHTML;
            const originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            if (hideTotal) {
                document.querySelectorAll('.total-row').forEach(el => {
                    el.style.display = 'none';
                });
            }

            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>

@endsection
