    <div class="page-content2">
        <img class="float-right quit-icon" onclick="document.getElementById('order-popup').style.display='none'"
            src="{{ asset('assets/pages/img/quit.svg') }}" alt="Close">
        <!-- BEGIN BREADCRUMBS -->
        <div class="breadcrumbs">
            <h1>Items Details</h1>
            <ol class="breadcrumb">
                <li>
                    <button class="btn btn-primary print" onclick="printDiv('printMe')">Print</button>
                </li>
            </ol>
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
        </div>
        <!-- END BREADCRUMBS -->
        <!-- BEGIN SIDEBAR CONTENT LAYOUT -->
        <style>
            .printOnly {
                display: none;
            }

            .quit-icon {
                float: right;
                width: 25px;
                height: 25px;
                cursor: pointer;
            }
        </style>
        <script>
            function printDiv(divName) {
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                $('tr').children().eq(1).hide();
                $('tr').children().eq(2).hide();
                $('tr').children().eq(9).hide();
                $('tr').children().eq(10).hide();
                $('table tr').find('td:eq(1)').hide();
                $('table tr').find('td:eq(2)').hide();
                $('table tr').find('td:eq(9)').hide();
                $('table tr').find('td:eq(10)').hide();
                window.print();
                document.body.innerHTML = originalContents;
            }
        </script>
        <div class="row">
            <div class="col-md-12">
                @if (!empty($o) && !empty($order) && $order->count() > 0)
                    @if ($order[0]->order_status != 'completed' || $order[0]->order_status != 'cancelled')
                        <span class="challan" style="position:absolute;right:5%;top:0%;">
                            <form action="/dashboard/order/singleChallan/{{ $o }}" method="post">
                                @csrf
                                <button type="submit" class="btn btn-success">Create Challan</button>
                            </form>
                        </span>
                    @endif
                @endif
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light portlet-fit bordered" id="printMe">
                    @if (!empty($order))
                        <p class="printOnly">{{ date('Y-m-d') }}</p>
                        <p class="printOnly">Marketing Officer: {{ $mo }}</p>
                        <p class="printOnly">Dealer: {{ $dealer }}</p>
                    @endif
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-paint-brush font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Orders</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_2">
                            <thead>
                                <tr>
                                    <th>Order No.</th>
                                    <th>Dealer</th>
                                    <th>User</th>
                                    <th>Date</th>
                                    <th>Category</th>
                                    <th>Product</th>
                                    <th>Rate</th>
                                    <th>Quantity</th>
                                    <th>Discount</th>
                                    <th>Cost</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $discount = 0;
                                $price = 0; ?>
                                @if (!empty($order))
                                    @foreach ($order as $ordr)
                                        <tr>
                                            <td>{{ $ordr->order_id }}</td>
                                            <td>{{ $ordr->dealer_name }}</td>
                                            <td>{{ $ordr->user_name }}</td>
                                            <td>{{ $ordr->order_date }}</td>
                                            <td>{{ $ordr->category_name }}</td>
                                            <td>{{ $ordr->product_name }}-{{ $ordr->size }}</td>
                                            <td>Rs. {{ $ordr->price / $ordr->quantity }}</td>
                                            <td>{{ $ordr->quantity }}</td>
                                            <td>Rs. {{ $ordr->discount }}</td>
                                            <td>Rs. {{ $ordr->price }}</td>
                                            <td>
                                                @if (isset($ordr->status) && $ordr->status == '0')
                                                    <a href="/dashboard/challan/edit/{{ $ordr->orderitems_id }}"
                                                        class="btn btn-primary btn-sm ab"
                                                        style="margin-bottom:2px;">Edit</a>
                                                @else
                                                    n-a
                                                @endif
                                            </td>
                                        </tr>
                                        <?php $price += $ordr->price;
                                        $discount += $ordr->discount; ?>
                                    @endforeach
                                    <tr>
                                        <td colspan="7" class="font-weight-bold">Total</td>
                                        <td colspan="4" class="font-weight-bold">{{ $price }}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" class="font-weight-bold">Discount</td>
                                        <td colspan="4" class="font-weight-bold">({{ $discount }})</td>
                                    </tr>
                                    <tr>
                                        <td colspan="7" class="font-weight-bold">Total after Discount</td>
                                        <td colspan="4" class="font-weight-bold">{{ $price - $discount }}</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
    </div>
