@extends('dashboards.sessions.layout')

@section('content')
<style>
    .dt-buttons {
        display: none;
    }

    .open {
        max-height: 200px !important;
        z-index: 2 !important;
    }
</style>
<div class="page-content">
    <div class="breadcrumbs">
        <h1>All Orders</h1>

        <!-- Sidebar Toggle Button -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
        <!-- Sidebar Toggle Button -->
    </div>

    <div class="page-content-container">
        <div class="page-content-row" id="replecable">
            <div class="page-sidebar">
                <div class="portlet light portlet-fit">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-bar font-red"></i>
                            <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                        </div>

                    </div>
                    <nav class="navbar" role="navigation">
                        <!-- Brand and toggle get grouped for better mobile display -->
                        <!-- Collect the nav links, forms, and other content for toggling -->
                        <ul class="nav navbar-nav margin-bottom-35 orders-class">
                            <li><a href="/dashboard/orders/pending">Pending </a></li>
                            <li><a href="/dashboard/orders/ongoing">Ongoing </a></li>
                            <li><a href="/dashboard/orders/completed">Completed </a></li>
                            <li><a href="/dashboard/orders/cancelled">Cancelled </a></li>
                            <li><a href="/dashboard/order/challan">Challan </a></li>
                        </ul>
                    </nav>
                </div>

            </div>

            <div class="page-content-col">
                @if( session('Status'))
                <div class="m-heading-1 border-green m-bordered">
                    <div class="page-content-col">
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    </div>
                </div>
                @endif
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light portlet-fit bordered">
                            <!-- BEGIN SIDEBAR CONTENT LAYOUT -->
                            <form method="post" class="page-content-container" action="/dashboard/order">
                                @csrf
                                <div class="row">

                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label bolds">Dealers<span class="required"></span></label>

                                            <select class="form-control selectpicker" name="dealer" id="dealer">
                                                <option value="">Select Dealers</option>
                                                <option value="">All</option>
                                                @foreach ($dealers as $dealer)
                                                <option value="{{ $dealer->id }}" @if(isset($dealer_id))@if($dealer_id==$dealer->id) selected @endif @else @if(old('dealer')==$dealer->id) selected @endif @endif >{{ $dealer->firm_name }}</option>
                                                @endforeach
                                            </select>
                                            <span class="field-validation-valid" data-valmsg-for="resCountry" data-valmsg-replace="true"></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label bolds">Order Status<span class="required"></span></label>

                                            <select class="form-control selectpicker" name="order_status" id="order_status">
                                                <option value="">Select Order Status</option>
                                                <option value="pending" @if($status=='pending' ) selected @endif>pending</option>
                                                <option value="ongoing" @if($status=='ongoing' ) selected @endif>ongoing</option>
                                                <option value="completed" @if($status=='completed' ) selected @endif>completed</option>
                                                <option value="cancelled" @if($status=='cancelled' ) selected @endif>cancelled</option>

                                            </select>
                                            <span class="field-validation-valid" data-valmsg-for="resCountry" data-valmsg-replace="true"></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label class="control-label bolds">From<span class="required has-feedback{{ $errors->has('start-date') ? ' has-error' : '' }}">*</span></label>
                                            <!-- <div class="date" data-provide="datepicker" class="form-control"> -->
                                            <!-- <input type="text" id="nepaliDateFa" autocomplete = "off" name="start-date" placeholder="YYYY-MM-DD" class="form-control nepali-calendar"> -->
                                            <!-- </div> -->
                                            <input type="date" id="start-date" onchange="myfunction()" name="start-date" value="{{$from}}" class="form-control">
                                            <span class="field-validation-valid" data-valmsg-for="education" data-valmsg-replace="true"></span>
                                            @if ($errors->has('start-date'))
                                            <span class="help-block required">
                                                <strong>{{ $errors->first('start-date') }}</strong>
                                            </span>
                                            @endif
                                            @if(session('status'))
                                            <span class="help-block required">
                                                <strong>{{ session('status') }}</strong>
                                                @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label class="control-label bolds">To<span class="required has-feedback{{ $errors->has('end-date') ? ' has-error' : '' }}">*</span></label>
                                            <!-- <div class="date" data-provide="datepicker" class="form-control">
                            <input type="text" id="nepaliDateF" autocomplete="off" name="end-date" placeholder="YYYY-MM-DD" class="form-control nepali-calendar">
                        </div> -->
                                            <input type="date" id="end-date" name="end-date" value="{{$to}}" class="form-control">
                                            <span class="field-validation-valid" data-valmsg-for="education" data-valmsg-replace="true"></span>
                                            @if ($errors->has('end-date'))
                                            <span class="help-block required">
                                                <strong>{{ $errors->first('end-date') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary" style="margin-top:24px;width: 100%;">View</button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="row">
                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light portlet-fit bordered">
                                        <div class="portlet-title">
                                            <div class="caption">
                                                <i class=" fa fa-paint-brush font-red"></i>
                                                <span class="caption-subject font-red bold uppercase">
                                                    
                                                    @if(Empty($start))
                                                    @if(!empty($de))

                                                    @if(empty($from) && empty($to))
                                                    Orders of The Day - {{$de}}

                                                    @elseif(!empty($from) && empty($to))
                                                    Orders of {{$de}} - ({{$from}})

                                                    @else
                                                    Orders of {{$de}} - ({{$from}} TO {{$to}})
                                                    @endif

                                                    @else

                                                    @if(empty($from) && empty($to))
                                                    Orders of The Day

                                                    @elseif(!empty($from) && empty($to))
                                                    Orders - ({{$from}} to Today)

                                                    @else
                                                    Orders - ({{$from}} TO {{$to}})
                                                    @endif

                                                    @endif
                                                    @else
                                                    Orders
                                                    @endif

                                                </span>
                                            </div>

                                        </div>
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="sample_2">
                                                <thead>
                                                    <tr>
                                                        <th> Order No.</th>
                                                        <th> Date </th>
                                                        <th> Dealer </th>
                                                        <th> User </th>
                                                        <th> Order Status </th>
                                                        <th> Details </th>
                                                        <th> View Log</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if (!empty($order))

                                                    @foreach($order as $ordr)
                                                    {{-- {{$id = $ordr->order_status}} --}}
                                                    <tr>
                                                        <td> {{$ordr->order_id}} </td>
                                                        <td> {{ $ordr->order_date }} </td>
                                                        <td> {{ $ordr->dealer_name }}</td>
                                                        <td> {{ $ordr->user_name }}</td>
                                                        <input type="hidden" class="order-hover" id="{{ $ordr->order_status }}">
                                                        <script>
                                                            $(document).ready(function() {
                                                                var id = $(".order-hover").attr('id');
                                                                $("." + id).attr('id', 'quickNav');
                                                            });
                                                        </script>
                                                        <td>

                                                            @if($ordr->order_id=="Summary")
                                                            {{$ordr->order_status}}
                                                            @else
                                                            <div>
                                                                @if ($ordr->order_status == 'pending')
                                                                <button type="button" data-api-parameter="{{ $ordr->order_id }},{{ $ordr->order_status }}" data-toggle="popover" class="btn btn-warning btn-sm ab">{{ $ordr->order_status }}</button>
                                                                @elseif ($ordr->order_status == 'cancelled')
                                                                <button type="button" data-api-parameter="{{ $ordr->order_id }},{{ $ordr->order_status }}" data-toggle="popover" class="btn btn-danger btn-sm ab">{{ $ordr->order_status }}</button>
                                                                @elseif($ordr->order_status == 'ongoing')
                                                                <button type="button" data-api-parameter="{{ $ordr->order_id }},{{ $ordr->order_status }}" data-toggle="popover" class="btn btn-info btn-sm ab">{{ $ordr->order_status }}</button>
                                                                @else
                                                                <button type="button" data-api-parameter="{{ $ordr->order_id }},{{ $ordr->order_status }}" data-toggle="popover" class="btn btn-success btn-sm ab">{{ $ordr->order_status }}</button>
                                                                @endif
                                                            </div>
                                                            <div name="myForm" data-toggle="popover" class="hide popover-content"></div>
                                                            @endif
                                                        </td>
                                                        <td>
                                                        @if($ordr->order_id=="Summary")
                                                        <a class="order-view-popup1" id="{{ $ordr->order_id }}">
                                                                <div class="btn btn-primary btn-sm" onclick="document.getElementById('order-popup').style.display='block'">All Order</div>
                                                            </a>
                                                            @else
                                                            <a class="order-view-popup1" id="{{ $ordr->order_id }}">
                                                                <div class="btn btn-primary btn-sm" onclick="document.getElementById('order-popup').style.display='block'">Item Details</div>
                                                            </a>
                                                            @endif
                                                            <!-- <a class = "allorder-view-popup" id = "{{ $ordr->order_id }}">
                                            <div class="btn btn-primary btn-sm" onclick = "document.getElementById('order-popup').style.display='block'">All Order</div></a> -->
                                                        </td>

                                                        <td>
                                                        @if($ordr->order_id=="Summary")
                                                            {{$ordr->order_status}}
                                                            @else
                                                            <a class="order-view-popup-log" id="{{ $ordr->order_id }}">
                                                                <div class="btn btn-primary btn-sm" onclick="document.getElementById('order-popup').style.display='block'">View Log</div>
                                                            </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach

                                                    @endif

                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- pop up after clicking view  --}}
                                        <div id="order-popup">

                                            {{-- href="/dashboard/order/{{ $ordr->order_id }}" --}}

                                        </div>

                                        <script>
                                            let status = {!!json_encode($status) !!};
                                            let dealer_id = {!!json_encode($dealer_id) !!};
                                            let from = {!!json_encode($from) !!};
                                            let to = {!!json_encode($to) !!};
                                            $(document).ready(function() {
                                                $(".order-view-popup1").click(function() {
                                                    var id = $(this).attr('id');
                                                    if(id=="Summary"){
                                                    $("#order-popup").load("/dashboard/orderfilter/?status=" + status + "&from=" + from +"&to=" + to + "&dealer_id=" +dealer_id);
                                                    }else{
                                                    $("#order-popup").load("/dashboard/order/" + id);
                                                    }
                                                    $("#order-pop").css("display", "block");
                                                    var modal = document.getElementById('order-popup');
                                                    window.onclick = function(event) {
                                                        if (event.target == modal) {
                                                            modal.style.display = "none";
                                                        }
                                                    }
                                                });

                                                $(".order-view-popup-log").click(function() {
                                                    var id = $(this).attr('id');
                                                    // if(dealer_id){
                                                    // $("#order-popup").load("/dashboard/orderlogpop/" + id + "/" + status);
                                                    // }else{
                                                    $("#order-popup").load("/dashboard/orderpop/" + id);
                                                    // }
                                                    $("#order-pop").css("display", "block");
                                                    var modal = document.getElementById('order-popup');
                                                    window.onclick = function(event) {
                                                        if (event.target == modal) {
                                                            modal.style.display = "none";
                                                        }
                                                    }
                                                });
                                                // $(".allorder-view-popup").click(function(){
                                                // var id =  $(this).attr('id');
                                                // $("#order-popup").load("/dashboard/allorder/"+ id);
                                                // $("#order-pop").css("display","block");
                                                // var modal = document.getElementById('order-popup');
                                                // window.onclick = function(event) {
                                                // if (event.target == modal) {
                                                //     modal.style.display = "none";
                                                // }
                                                // }
                                                // });



                                            });
                                        </script>

                                    </div>
                                    <!-- END EXAMPLE TABLE PORTLET-->
                                </div>

                                <!-- END SIDEBAR CONTENT LAYOUT -->
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function myfunction() {
        var endinput1 = document.getElementById("end-date");
        var selectedDate = document.getElementById("start-date");
        today2 = new Date(selectedDate.value);
        var day2 = new String(today2.getDate());

        // Set month to string to add leading 0
        var mon2 = new String(today2.getMonth() + 1); //January is 0!
        var yr2 = today2.getFullYear();
        // console.log(mon)
        if (mon2.length < 2) {
            mon2 = "0" + mon2;
        }
        if (day2.length < 2) {
            day2 = "0" + day2;
        }

        var date2 = new String(yr2 + '-' + mon2 + '-' + day2);
        endinput1.disabled = false;
        endinput1.setAttribute('min', date2);
    }
    $(function() {
            $('[data-toggle="popover"]').popover({
               trigger: 'click',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                placement: 'right',
                title: '<b>Change Order Status</b>',
                // title:' <button onclick="closePopover();" class="btn btn-danger">Close</button>',
                html: true
    }).on('shown.bs.popover', function () {
        
        var popover = $(this);

        var contentEl = popover.next(".popover").find(".popover-content");       
        var myParameter = popover.data('api-parameter');  
        var res = myParameter.split(",");
        // var previousStatus = popover.data('name');
        // console.log(myParameter);

          var result = '<form action="/dashboard/order/'+res[0]+'" id="popForm" method="post">' +
                                                    '<input type="hidden" name="_method" value="PATCH">' +
                                                    '<input type="hidden" name="_token" value="<?php echo csrf_token(); ?>">' +
                                                    '<input type="hidden" name="previous_status" value="'+res[1]+'">'+
                                                    '<div><label for="status">Status:</label>'+
                                                        '<select name="status" id="status" class="form-control input-md"><option value="pending">pending</option><option value="ongoing">ongoing</option><option value="completed">completed</option><option value="cancelled">cancelled</option></select><br>'+
                                                        '<label for="status">Remark:</label>'+
                                                        '<input type = "text" name="remark" class="form-control" required><br>'+
                                                        '<button type="submit" class="btn btn-primary">Update</button>'+
                                                       
                                                    '</div></form>'+'<img style = "position:absolute;top:-8px; right:-8px;width:25px; height:25px;" onclick="closePopover();" id="popoverClose" src={{ asset('assets/pages/img/quit.svg') }}>';

          
          // contentEl.toggle();
          contentEl.html(result);
        });
    });
</script>
@endsection