@extends('dashboards.sessions.layout')

@section('content')
    <style>
        .dt-buttons {
            display: none;
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>All Product Details</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            <ul class="nav navbar-nav margin-bottom-35 products-class">
                                @include('dashboards.sidebarLayouts.products')
                            </ul>

                        </nav>
                    </div>

                </div>

                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <style>
                        .productImage {
                            height: 100px;
                            width: 100px;
                            margin-left: 22%;
                        }
                    </style>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class=" fa fa-paint-brush font-red"></i>
                                        <span class="caption-subject font-red bold uppercase"> Product Details List </span>
                                    </div>
                                    {{-- <a href="/dashboard/exportproduct" class="btn btn-outline btn-xs btn-primary"
                                        style="float:right">.xlsx</a> --}}

                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="sample_2">
                                        <thead>
                                            <tr>
                                                <th>Product Image</th>
                                                <th> Product Name </th>
                                                <th> Coverage (ft²/gal) </th>
                                                <th> Actions </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($productDetails as $product)
                                                <tr>
                                                    <td>
                                                        @if ($product['image'])
                                                            <img class="productImage"
                                                                src="{{ asset('storage/' . $product['image']) }}"
                                                                srcset="">
                                                        @else
                                                            <img class="productImage"
                                                                src="{{ asset('assets/pages/img/logos/logo.png') }}"
                                                                srcset="">
                                                        @endif
                                                    </td>

                                                    <td>{{ $product['name'] }}</td>
                                                    <td>{{ $product['coverageFt2PerGallon'] }} ft²/gal</td>
                                                    <td>
                                                        <div class='btn-group'>
                                                            <div>
                                                                <a href="{{ route('product-details.edit', $product['id']) }}"
                                                                    class='btn green btn-outline btn-xs'
                                                                    style="margin-right:5px;">Edit</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>


                        <!-- END SIDEBAR CONTENT LAYOUT -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
