@extends('dashboards.sessions.layout')

@section('content')
    <style>
        .dt-buttons {
            display: none;
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>All Final Products</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            <ul class="nav navbar-nav margin-bottom-35 products-class">
                                @include('dashboards.sidebarLayouts.products')
                            </ul>

                        </nav>
                    </div>

                </div>

                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <style>
                        .productImage {
                            height: 100px;
                            width: 100px;
                            margin-left: 22%;
                        }
                    </style>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class=" fa fa-paint-brush font-red"></i>
                                        <span class="caption-subject font-red bold uppercase"> Product List </span>
                                    </div>
                                    <a href="/dashboard/exportproduct" class="btn btn-outline btn-xs btn-primary"
                                        style="float:right">.xlsx</a>

                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="sample_2">
                                        <thead>
                                            <tr>
                                                <th>Product Image</th>
                                                <th> Product Name </th>
                                                <th> Variant </th>
                                                <th> Price </th>
                                                <th> Actions </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($products as $product)
                                                <tr>
                                                    <td>
                                                        <a href="/dashboard/product/images/{{ $product['id'] }}/all">
                                                            @if ($product['image'])
                                                                <img class="productImage"
                                                                    src="{{ asset('/storage/' . $product['image']) }}"
                                                                    srcset="">
                                                            @else
                                                                <img class="productImage"
                                                                    src="{{ asset('assets/pages/img/logos/logo.png') }}"
                                                                    srcset="">
                                                            @endif
                                                        </a>
                                                    </td>

                                                    <td>{{ $product['name'] }}</td>
                                                    <td>{{ $product['size'] }}</td>
                                                    <td>Rs. {{ $product['price'] }}</td>
                                                    <td>

                                                        <div class='btn-group'>
                                                            <div>
                                                                <a id = "{{ $product['id'] }}"
                                                                    onclick = "document.getElementById('order-popup').style.display='block'"
                                                                    class="btn btn-primary btn-outline btn-xs image-view-popup"
                                                                    style="margin-right:5px;">Add Images</a>
                                                            </div>
                                                            <div>
                                                                <a href="/dashboard/productfinal/{{ $product['id'] }}/edit"
                                                                    class='btn green btn-outline btn-xs'
                                                                    style="margin-right:5px;">Edit</a>
                                                            </div>
                                                            <form method="POST"
                                                                action="/dashboard/product/status/{{ $product['id'] }}">
                                                                @method('patch')
                                                                @csrf
                                                                @if ($product['status'] == '1')
                                                                    <input type="hidden" value="0" name="status">
                                                                    <div>

                                                                        <button type="submit"
                                                                            class='btn btn-outline btn-xs btn-primary'
                                                                            style="margin-right:5px;">Enable</button>
                                                                    </div>
                                                                @else
                                                                    <input type="hidden" value="1" name="status">
                                                                    <div>
                                                                        <button type="submit"
                                                                            class='btn btn-danger btn-outline btn-xs'
                                                                            style="margin-right:5px;">Disable</button>
                                                                    </div>
                                                                @endif
                                                            </form>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div id = "order-popup">



                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>


                        <!-- END SIDEBAR CONTENT LAYOUT -->
                    </div>
                </div>
                <script>
                    $(document).ready(function() {
                        $(".order-view-popup").click(function() {
                            var id = $(this).attr('id');
                            $("#order-popup").load("/dashboard/product/" + id + "/edit");
                            $("#order-pop").css("display", "block");
                            var modal = document.getElementById('order-popup');
                            window.onclick = function(event) {
                                if (event.target == modal) {
                                    modal.style.display = "none";
                                }
                            }
                        });

                        $(".image-view-popup").click(function() {
                            var id = $(this).attr('id');
                            // alert(id);
                            $("#order-popup").load("/dashboard/product/images/" + id);
                            $("#order-pop").css("display", "block");
                            var modal = document.getElementById('order-popup');
                            window.onclick = function(event) {
                                if (event.target == modal) {
                                    modal.style.display = "none";
                                }
                            }
                        });

                    });
                </script>
            </div>
        </div>
    </div>
@endsection
