@extends('dashboards.blank')

@section('content')
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>Edit Assigned Product With Variant</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>

        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            <!-- Brand and toggle get grouped for better mobile display -->
                            <!-- Collect the nav links, forms, and other content for toggling -->
                            <ul class="nav navbar-nav margin-bottom-35 products-class">
                                @include('dashboards.sidebarLayouts.products')
                            </ul>

                        </nav>
                    </div>

                </div>

                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class=" icon-map font-red"></i>
                                        <span class="caption-subject font-red bold uppercase">Assign Product With
                                            Variant</span>
                                    </div>

                                </div>

                                @if (count($errors) > 0)
                                    @foreach ($errors->all() as $error)
                                        <p class="alert alert-danger">{{ $error }}</p>
                                    @endforeach
                                @endif

                                <form method="POST" action="/dashboard/productfinal/{{ $productinfo->id }}"
                                    enctype="multipart/form-data">
                                    @method('patch')
                                    @csrf

                                    <div class="form-group row">
                                        <label for="name"
                                            class="col-md-3 col-form-label text-right">{{ __('Product Name ') }}</label>

                                        <div class="col-md-6">
                                            <input type="text" class="form-control"
                                                value="{{ $product->product['name'] }}" disabled>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="variant"
                                            class="col-md-3 col-form-label text-right">{{ __('Variant ') }}</label>
                                        <div class="col-md-6">
                                            <select name="variant" class="form-control" required>
                                                <option value="">Select Variant</option>
                                                @foreach ($size as $sizes)
                                                    <option value="{{ $sizes->id }}"
                                                        @if ($productinfo->size_id == $sizes->id) selected @endif>
                                                        {{ $sizes->size }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="price"
                                            class="col-md-3 col-form-label text-right">{{ __('Price (Rs.) ') }}</label>
                                        <div class="col-md-6">
                                            <input type="text" class="form-control" value="{{ $productinfo->price }}"
                                                name="price" placeholder="price" required autofocus>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="image"
                                            class="col-md-3 col-form-label text-right">{{ __('Product Image') }}</label>

                                        <div class="col-md-6">
                                            <input type="file" name="image" class="form-control" autofocus>
                                        </div>

                                    </div>

                                    <div class="form-group row mb-0">
                                        <div class="col-md-6 col-md-offset-3">
                                            <button type="submit" class="btn btn-primary" style="width: 200px;">
                                                {{ __('Update') }}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
