@extends('dashboards.blank')

@section('content')
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>All Shades</h1>
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only"> Toogle Navigation </span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
        </div>
        <style>
            .link {
                position: absolute;
                bottom: 20px;
                right: 44px;
            }

            .img {
                margin-left: 40%;
                width: 25px;
                height: 25px;
            }
        </style>
        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <b>{{ session('Status') }}</b>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <span style="float:right">Search:
                                        <input type="text" id="shade-search" placeholder="Search shade by name or code"
                                            class="form-control">
                                    </span>
                                    <div class="caption">
                                        <span class="caption-subject font-red bold uppercase">shades</span>
                                    </div>
                                    <div class="protlet-body">
                                        <div id="data-fetch">
                                            @include('dashboards.shadecolors.table')
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#shade-search').on('keyup', function() {
                let query = $(this).val();

                $.ajax({
                    url: "/dashboard/shadesearch",
                    type: "GET",
                    data: {
                        string: query
                    },
                    success: function(data) {
                        $('#data-fetch').html(data);
                    },
                    error: function() {
                        alert('Failed to fetch data');
                    }
                });
            });
        });
    </script>
@endsection
