@extends('dashboards.blank')

@section('content')
    <style>
        input[type=text] {
            width: 100%;
        }

        .discount-header {
            height: 50px;
            background-color: #d7d7d7;
            border-radius: 3px;
            display: flex;
            align-items: center;
            padding-left: 16px;
            margin-bottom: 16px;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .product-category {
            border: 1px solid #d1d1d1;
            max-height: 350px;
            overflow-y: auto;
            overflow-x: hidden;
            border-radius: 5px;
        }

        .product-label {
            padding-left: 16px;
            border: 0px;
        }

        .product-label:focus {
            outline: none;
        }
    </style>
    <div class="page-content">
        <div class="breadcrumbs">
            <h1>Register New User</h1>
            <!-- Sidebar Toggle Button -->
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- Sidebar Toggle Button -->
        </div>
        <div class="page-content-container">
            <div class="page-content-row" id="replecable">
                <div class="page-sidebar">
                    <div class="portlet light portlet-fit">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class=" icon-bar font-red"></i>
                                <span class="caption-subject font-red bold uppercase">Quick Navigation</span>
                            </div>

                        </div>
                        <nav class="navbar" role="navigation">
                            <!-- Brand and toggle get grouped for better mobile display -->
                            <!-- Collect the nav links, forms, and other content for toggling -->
                            @include('dashboards.sidebarLayouts.user')

                        </nav>
                    </div>

                </div>

                <div class="page-content-col">
                    @if (session('Status'))
                        <div class="m-heading-1 border-green m-bordered">
                            <div class="page-content-col">
                                <div class="alert alert-success alert-dismissible" role="alert">
                                    <b>{{ session('Status') }}</b>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light portlet-fit bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <i class=" fa fa-user font-red"></i>
                                        <span class="caption-subject font-red bold uppercase">Add New User</span>
                                    </div>

                                </div>

                                @if (count($errors) > 0)
                                    @foreach ($errors->all() as $error)
                                        <p class="alert alert-danger">{{ $error }}</p>
                                    @endforeach
                                @endif

                                <form method="POST" action="/dashboard/addMobileUser">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group row">
                                                <label for="role_id" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('User Role') }}</label>
                                                <div class="col-md-8">
                                                    <select name="role" class="form-control" id="mySelect"
                                                        onchange="myFunction()">

                                                        <option value="">Select User Role</option>
                                                        <option value="1"
                                                            @if (old('role') == 1) selected @endif>Dealer
                                                        </option>
                                                        <option value="2"
                                                            @if (old('role') == 2) selected @endif>Staff on
                                                            Dealer</option>
                                                        <option value="3"
                                                            @if (old('role') == 3) selected @endif>Company Staff
                                                        </option>

                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="name" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('First Name') }}</label>

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control" value="{{ old('fname') }}"
                                                        name="fname" placeholder="First Name" required autofocus>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="name" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Last Name') }}</label>

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control" value="{{ old('lname') }}"
                                                        name="lname" placeholder=" Last Name" required autofocus>
                                                </div>
                                            </div>
                                            <div class="form-group row company">
                                                <label for="name" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Organization/Dealer Name') }}</label>

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control edName"
                                                        value="{{ old('dealer') }}" name="dealer"
                                                        placeholder=" Organization/Dealer Name" required autofocus>
                                                </div>
                                            </div>
                                            <div class="form-group row company">
                                                <label for="name" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Organization/Dealer code') }}</label>

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control edName"
                                                        value="{{ old('code') }}" name="code"
                                                        placeholder="Organization/Dealer code" required autofocus>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="email" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Login User Id Code') }}</label>

                                                <div class="col-md-8">
                                                    <input id="text" type="text" class="form-control"
                                                        name="user_code" placeholder="user_id"
                                                        value="{{ old('user_code') }}" required autofocus>

                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="address" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Complete Address') }}</label>

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control"
                                                        value="{{ old('address') }}" name="address"
                                                        placeholder="Address" required autofocus>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="phone" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Phone Number') }}</label>

                                                <div class="col-md-8">
                                                    <input type="number" class="form-control" name="phone"
                                                        value="{{ old('phone') }}" placeholder="phone" required
                                                        autofocus>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="password" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Password') }}</label>

                                                <div class="col-md-8">
                                                    <input type="password" class="form-control" name="password"
                                                        placeholder="password" required autofocus>

                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="password" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Confirm Password') }}</label>

                                                <div class="col-md-8">
                                                    <input type="password" class="form-control"
                                                        name="password_confirmation" placeholder="Confirm Password"
                                                        required autofocus>
                                                </div>
                                            </div>
                                            <div class="form-group row" id="order-limit">
                                                <label for="phone" class="col-md-3 col-form-label "
                                                    style="margin-left:10px;">{{ __('Order Limit(Rs.)') }}</label>

                                                <div class="col-md-8">
                                                    <input type="number" class="form-control" id="limit"
                                                        name="limit" value="{{ old('limit') }}"
                                                        placeholder="Rs. 0000" required autofocus>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="product-category">
                                                <div class="discount-header">Discount on Product</div>
                                                <div class="form-group row">
                                                    <label for="phone" class="col-md-4 col-form-label "
                                                        style="margin-left:16px;">{{ __('Discount for all product') }}</label>
                                                    <div class="col-md-5">
                                                        <input type="number" step="0.01" min="0"
                                                            max="100" class="form-control" id="discount_apply"
                                                            style="margin-right:16px;" placeholder="discount percentage"
                                                            autofocus>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <a class="btn btn-primary btn-sm" onclick="applyDiscount()"
                                                            style="width: 123%;">Apply</a>
                                                    </div>
                                                </div>
                                                @foreach ($categories as $category)
                                                    <div class="form-group">
                                                        <label for="phone"
                                                            class="col-md-12 product-label">{{ $category->name }}</label>
                                                        <input for="category" name="product_name[]"
                                                            class="col-md-12 product-label" value="{{ $category->id }}"
                                                            readonly type="hidden" />
                                                        <div class="col-md-12">
                                                            <input type="number" min="0" max="100"
                                                                step="0.01" class="form-control discount-product"
                                                                name="discount[]" value="{{ old('discount') }}"
                                                                placeholder="discount (percentage)" autofocus>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div class="form-group row mb-0">
                                                <div class="col-md-8">
                                                    <button type="submit" class="btn btn-primary"
                                                        style="width: 200px;margin-top:20px;">
                                                        {{ __('Create') }}
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function myFunction() {
            var x = document.getElementById("mySelect").value;
            if (x == 3) {
                var hello = document.getElementsByClassName('company');
                hello[0].style.display = "none";
                hello[1].style.display = "none";
                var require = document.getElementsByClassName("edName");
                let ord = document.getElementById('order-limit');
                ord.style.display = "none"
                require[0].removeAttribute("required");
                require[1].removeAttribute("required");
                // require[0].required = false;
                // require[1].required = false;
                let limit = document.getElementById('limit');
                limit.removeAttribute("required");
                let productcategory = document.querySelector('.product-category');
                productcategory.style.display = "none"
            } else {
                var hello = document.getElementsByClassName('company');
                hello[0].style.display = "block";
                hello[1].style.display = "block";
                var require = document.getElementsByClassName("edName");
                document.getElementById('order-limit').style.display = "block";
                require[0].setAttribute("required", "");
                require[1].setAttribute("required", "");
                let ord = document.getElementById('order-limit');
                ord.style.display = "block"
                let limit = document.getElementById('limit');
                limit.setAttribute("required", "");
                let productcategory = document.querySelector('.product-category');
                productcategory.style.display = "block"
            }
            if (x == 2) {
                let ord = document.getElementById('order-limit');
                ord.style.display = "none"
                let productcategory = document.querySelector('.product-category');
                productcategory.style.display = "none"
                let limit = document.getElementById('limit');
                limit.removeAttribute("required");
            }
        }
        window.onload = myFunction;

        function applyDiscount() {
            let discount = document.getElementById('discount_apply').value;
            let discountField = document.querySelectorAll('.discount-product');
            // if(discount){
            discountField.forEach(function(item) {
                item.value = discount;
            });
            // }
        }
    </script>
@endsection
